% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{plot.bcp}
\alias{plot.bcp}
\title{Plotting Bayesian change point results}
\usage{
\method{plot}{bcp}(x, separated = FALSE, outer.margins = list(left =
  unit(4, "lines"), bottom = unit(3, "lines"), right = unit(2, "lines"),
  top = unit(2, "lines")), lower.area = unit(0.33, "npc"),
  size.points = unit(0.25, "char"), pch.points = 20, colors = NULL,
  main = NULL, xlab = NULL, xaxlab = NULL,
  cex.axes = list(cex.xaxis = 0.75, cex.yaxis.lower = 0.75,
  cex.yaxis.upper.default = 0.75, cex.yaxis.upper.separated = 0.5),
  lwd = 1, ...)
}
\arguments{
\item{x}{the result of a call to \code{bcp()}.}

\item{separated}{logical. If set to \code{TRUE} and the data is multivariate, each series is plotted separately.}

\item{outer.margins}{(optional) list of units specifying the left, bottom, right and top margins.  For more information on units, see the documentation for \code{grid}.}

\item{lower.area}{(optional) unit specifying the proportion of the plot occupied by the posterior probabilities of change points.}

\item{size.points}{(optional) unit specifying the size of the data points.}

\item{pch.points}{(optional) unit specifying the style of the data points.}

\item{colors}{(optional) vector specifying the colors in which to plot each data series.}

\item{main}{(optional) plot title. Use \code{""} for no title.}

\item{xlab}{(optional) a character string specifying the x-axis label. Defaults to "Location".}

\item{xaxlab}{(optional) a vector having length equal to the number of observations giving the x-axis tick labels. Defaults to the sequence from 1 to n.}

\item{cex.axes}{(optional) list specifying the sizes of the axes labels. \code{cex.xaxis} specifies the size of the x-axis label, \code{cex.yaxis.lower} specifies the size of the y-axis label of the posterior probability plot, \code{cex.yaxis.upper.default} specifies the size of the y-axis labels of the posterior means plot when the series are displayed in a single plot, and \code{cex.yaxis.upper.separated} specifies the size of the y-axis labels of the posterior means plots when each series is plotted separately.}

\item{lwd}{line width}

\item{...}{(optional) additional arguments, ignored.}
}
\description{
\code{plot.bcp()} produces summary plots of the results of \code{bcp()}. Currently, only the summary plots for serial data are implemented. 
If an adjacency structure (adj) is provided, then the data are assumed to reside on nodes of a general graph. Additional parameters are used in this graph change point model.
}
\details{
\code{plot.bcp()} produces the following plots using \code{grid} graphics instead of \code{base}:
  
 Posterior Means: location in the sequence versus the posterior means over the iterations. 

 Posterior Probability of a Change: location in the sequence versus the relative frequency of iterations which resulted in a change point.
}
\examples{
testdata <- cbind( c(rnorm(50), rnorm(50, -5, 1), rnorm(50)),
c(rnorm(50), rnorm(50, 10.8, 1), rnorm(50, -3, 1)) )
bcp.0 <- bcp(testdata)
plot(bcp.0, main="Multivariate (k=2) Change Point Example")
plot(bcp.0, separated=TRUE, main="Multivariate (k=2) Change Point Example")

}
\seealso{
\code{\link{legacyplot}}, \code{\link{bcp}}, \code{\link{summary.bcp}}, and \code{\link{print.bcp}} for complete results and summary statistics.
}
\author{
Xiaofei Wang, Chandra Erdman, and John W. Emerson
}
\keyword{datasets}
