% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bcp.R
\name{bcpExport}
\alias{bcpExport}
\title{Export data from SQL Server}
\usage{
bcpExport(
  file,
  connectargs,
  table,
  query,
  fieldterminator = "\\t",
  rowterminator = ifelse(.Platform$OS.type == "windows", "\\r\\n", "\\n"),
  bcpOptions = list("-c", "-b", 1000, "-a", 4096, "-m", 10),
  ...
)
}
\arguments{
\item{file}{output file name}

\item{connectargs}{named list of connection arguments. See \link[bcputility]{makeConnectArgs}.}

\item{table}{name of the source table when exporting from  SQL Server}

\item{query}{Transact-SQL query that returns a result set. Ignored if
table is specified.}

\item{fieldterminator}{character separator for columns}

\item{rowterminator}{character separator for rows--new lines}

\item{bcpOptions}{list of additional options to pass to the \code{bcp} utility. See details.}

\item{...}{arguments to pass \link[base]{system2}}
}
\value{
No return value. Operations from bcp are printed to console; see
\code{...} to redirect output
}
\description{
A wrapper for a system call to the bcp utility which writes a SQL Server
table or query (T-SQL) to a file.
}
\details{
The \code{bcpOptions} allows the user to include additional arguments for the
call to \code{system2}. Please refer to
\url{https://learn.microsoft.com/en-us/sql/tools/bcp-utility}.
The default options are set
to the defaults for \code{bcp} CLI. \code{-b} refers to
number of rows to write at a time; 10,000 to 50,000 is a
starting recommendation. \code{-a} refers to size of packets to be sent in
bytes. \code{-e} refers to the maximum number of errors before failure.
}
