% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{Posterior.exact}
\alias{Posterior.exact}
\title{Returns posterior mean parameter value and summaries of distributions for probability of DLT at each dose level}
\usage{
Posterior.exact(tox, notox, sdose, ff, prior.alpha)
}
\arguments{
\item{tox}{A vector of length \code{k} showing the number of patient who had toxicities at each dose level}

\item{notox}{A vector of length \code{k} showing the number of patients who did not have toxicities at each dose level}

\item{sdose}{A vector of length \code{k} listing the standardised doses to
be used in the CRM model.}

\item{ff}{A string indicating the functional form of the dose-response
curve. Options are \describe{ \item{ht}{ 1-parameter hyperbolic tangent}
\item{logit1}{ 1-parameter logistic} \item{power}{ 1-parameter power}
\item{logit2}{ 2-parameter logistic} }}

\item{prior.alpha}{A list of length 3 containing the distributional
information for the prior. The first element is a number from 1-4 specifying
the type of distribution. Options are \enumerate{ \item Gamma(a, b),  where
a=shape,  b=scale: mean=a*b,  variance=a*b*b \item Uniform(a, b),  where a=min, 
b=max \item Lognormal(a, b),  where a=mean on the log scale,  b=variance on the
log scale \item Bivariate Lognormal(a, b),  where a=mean vector on the log
scale,  b=Variance-covariance matrix on the log scale. This prior should be
used only in conjunction with a two-parameter logistic model.  } The second
and third elements of the list are the parameters a and b,  respectively.}
}
\description{
Returns posterior mean parameter value and summaries of distributions for probability of DLT at each dose level
}
\examples{

## Dose-escalation cancer trial example as described in Neuenschwander et al 2008.
## Pre-defined doses
dose <- c(1, 2.5, 5, 10, 15, 20, 25, 30, 40, 50, 75, 100, 150, 200, 250)
## Pre-specified probabilities of toxicity
## [dose levels 11-15 not specified in the paper,  and are for illustration only]
p.tox0 <- c(0.010, 0.015, 0.020, 0.025, 0.030, 0.040, 0.050,
  0.100, 0.170, 0.300, 0.400, 0.500, 0.650, 0.800, 0.900)
## Data from the first 5 cohorts of 18 patients
tox <- c(0, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0)
notox <- c(3, 4, 5, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
## Target toxicity level
target.tox <- 0.30

## Prior distribution for the MTD given a lognormal(0, 1.34^2) distribution for alpha
## and a power model functional form
prior.alpha <- list(3, 0, 1.34^2)
ff <- "power"
samples.alpha <- getprior(prior.alpha, 2000)
mtd <- find.x(ff, target.tox, alpha=samples.alpha)
hist(mtd)

## Standardised doses
sdose <- find.x(ff, p.tox0, alpha=1)

## Posterior distribution of the MTD (on standardised dose scale) using data 
## from the cancer trial described in Neuenschwander et al 2008.
posterior.samples <- Posterior.exact(tox, notox, sdose, ff, prior.alpha)

}
\references{
Sweeting M.,  Mander A.,  Sabin T. \pkg{bcrm}: Bayesian Continual
Reassessment Method Designs for Phase I Dose-Finding Trials. \emph{Journal
of Statistical Software} (2013) 54: 1--26.
\url{http://www.jstatsoft.org/article/view/v054i13}
}
\seealso{
\code{\link{bcrm}},  \code{\link{find.x}}
}
\author{
Michael Sweeting \email{mjs212@medschl.cam.ac.uk} (University of
Cambridge,  UK),  drawing on code originally developed by J. Jack Lee and Nan
Chen,  Department of Biostatistics,  the University of Texas M. D. Anderson
Cancer Center
}
