% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bdc_eventDate_empty.R
\name{bdc_eventDate_empty}
\alias{bdc_eventDate_empty}
\title{Identify records with empty event date}
\usage{
bdc_eventDate_empty(data, eventDate = "eventDate")
}
\arguments{
\item{data}{A data frame containing column with event date information.}

\item{eventDate}{Numeric or date. The column with event date information.}
}
\value{
A data.frame containing the column ".eventDate_empty". Compliant
(TRUE) if 'eventDate' is not empty; otherwise "FALSE".
}
\description{
This function identifies records missing information on an event date (i.e.,
when a record was collected or observed).
}
\details{
This test identifies records missing event date information (i.e.,
empty or not applicable \link{NA}).
}
\examples{
collection_date <- c(
  NA, "31/12/2015", "2013-06-13T00:00:00Z", "2013-06-20",
  "", "2013", "0001-01-00"
)
x <- data.frame(collection_date)

bdc_eventDate_empty(data = x, eventDate = "collection_date")

}
\seealso{
Other time: 
\code{\link{bdc_year_from_eventDate}()},
\code{\link{bdc_year_outOfRange}()}
}
\concept{time}
