% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FindHashtagPipe.R
\name{FindHashtagPipe}
\alias{FindHashtagPipe}
\title{Class to find and/or remove the hashtags on the data field of an Instance}
\description{
This class is responsible of detecting the existing hashtags in the
\strong{data} field of each \code{\link{Instance}}. Identified hashtags are
stored inside the \strong{hashtag} field of \code{\link{Instance}} class.
Moreover if required, is able to perform inline hashtag removement.
}
\section{Details}{

The regular expression indicated in the \code{hashtagPattern}
variable is used to identify hashtags.
}

\section{Note}{

\code{\link{FindHashtagPipe}} will automatically invalidate the
\code{\link{Instance}} whenever the obtained data is empty.
}

\section{Inherit}{

This class inherits from \code{\link{GenericPipe}} and implements the
\code{pipe} abstract function.
}

\seealso{
\code{\link{AbbreviationPipe}}, \code{\link{ContractionPipe}},
         \code{\link{File2Pipe}}, \code{\link{FindEmojiPipe}},
         \code{\link{FindEmoticonPipe}}, \code{\link{FindUrlPipe}},
         \code{\link{FindUserNamePipe}}, \code{\link{GuessDatePipe}},
         \code{\link{GuessLanguagePipe}}, \code{\link{Instance}},
         \code{\link{InterjectionPipe}}, \code{\link{MeasureLengthPipe}},
         \code{\link{GenericPipe}}, \code{\link{SlangPipe}},
         \code{\link{StopWordPipe}}, \code{\link{StoreFileExtPipe}},
         \code{\link{TargetAssigningPipe}}, \code{\link{TeeCSVPipe}},
         \code{\link{ToLowerCasePipe}}
}
\section{Super class}{
\code{\link[bdpar:GenericPipe]{bdpar::GenericPipe}} -> \code{FindHashtagPipe}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{hashtagPattern}}{A \code{\link{character}} value. The regular
expression to detect hashtags.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FindHashtagPipe-new}{\code{FindHashtagPipe$new()}}
\item \href{#method-FindHashtagPipe-pipe}{\code{FindHashtagPipe$pipe()}}
\item \href{#method-FindHashtagPipe-findHashtag}{\code{FindHashtagPipe$findHashtag()}}
\item \href{#method-FindHashtagPipe-removeHashtag}{\code{FindHashtagPipe$removeHashtag()}}
\item \href{#method-FindHashtagPipe-clone}{\code{FindHashtagPipe$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getAlwaysBeforeDeps'><code>bdpar::GenericPipe$getAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getNotAfterDeps'><code>bdpar::GenericPipe$getNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="getPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-getPropertyName'><code>bdpar::GenericPipe$getPropertyName()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="hash"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-hash'><code>bdpar::GenericPipe$hash()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setAlwaysBeforeDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setAlwaysBeforeDeps'><code>bdpar::GenericPipe$setAlwaysBeforeDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setNotAfterDeps"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setNotAfterDeps'><code>bdpar::GenericPipe$setNotAfterDeps()</code></a></li>
<li><span class="pkg-link" data-pkg="bdpar" data-topic="GenericPipe" data-id="setPropertyName"><a href='../../bdpar/html/GenericPipe.html#method-GenericPipe-setPropertyName'><code>bdpar::GenericPipe$setPropertyName()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindHashtagPipe-new"></a>}}
\if{latex}{\out{\hypertarget{method-FindHashtagPipe-new}{}}}
\subsection{Method \code{new()}}{
Creates a \code{\link{FindHashtagPipe}} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindHashtagPipe$new(
  propertyName = "hashtag",
  alwaysBeforeDeps = list(),
  notAfterDeps = list(),
  removeHashtags = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{propertyName}}{A \code{\link{character}} value. Name of the property
associated with the \code{\link{GenericPipe}}.}

\item{\code{alwaysBeforeDeps}}{A \code{\link{list}} value. The dependencies
alwaysBefore (\code{\link{GenericPipe}s} that must be executed before
this one).}

\item{\code{notAfterDeps}}{A \code{\link{list}} value. The dependencies
notAfter (\code{\link{GenericPipe}s} that cannot be executed after
this one).}

\item{\code{removeHashtags}}{A \code{\link{logical}} value. Indicates if the
hashtags are removed.}

\item{\code{propertyLanguageName}}{A \code{\link{character}} value. Name of the
language property.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindHashtagPipe-pipe"></a>}}
\if{latex}{\out{\hypertarget{method-FindHashtagPipe-pipe}{}}}
\subsection{Method \code{pipe()}}{
Preprocesses the \code{\link{Instance}} to obtain/remove
the hashtags. The hashtags found in the data are added to the
list of properties of the \code{\link{Instance}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindHashtagPipe$pipe(instance)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{instance}}{A \code{\link{Instance}} value. The \code{\link{Instance}}
to preprocess.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{Instance}} with the modifications that have
occurred in the pipe.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindHashtagPipe-findHashtag"></a>}}
\if{latex}{\out{\hypertarget{method-FindHashtagPipe-findHashtag}{}}}
\subsection{Method \code{findHashtag()}}{
Finds the \emph{hashtags} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindHashtagPipe$findHashtag(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text to search the
hashtags.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{\link{list}} with hashtags found.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindHashtagPipe-removeHashtag"></a>}}
\if{latex}{\out{\hypertarget{method-FindHashtagPipe-removeHashtag}{}}}
\subsection{Method \code{removeHashtag()}}{
Removes the \emph{hashtags} in the data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindHashtagPipe$removeHashtag(data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{\link{character}} value. The text where hashtags
will be removed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The data with the hashtags removed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FindHashtagPipe-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FindHashtagPipe-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FindHashtagPipe$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
