% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tournament.R
\name{evaluate_game}
\alias{evaluate_game}
\title{Compare two models using Bayes factor}
\usage{
evaluate_game(m, winning_criteria = 0.75)
}
\arguments{
\item{m}{a list of two model objects fit on the same dataset. Model objects allowed are "gplm", "gplm0", "plm" and "plm0"}

\item{winning_criteria}{a numerical value between 0 and 1 which sets the threshold for which the probability of the first model in the list, given the data and calculated using Bayes factor, must exceed for it to be declared the better model of the two. This value defaults to 0.75.}
}
\value{
A data.frame with the summary of the results of the game
}
\description{
evaluate_game uses the Bayes factor of two models to determine whether one model favors the other
}
\references{
B. Hrafnkelsson, H. Sigurdarson, S.M. Gardarsson, 2020, Generalization of the power-law rating curve using hydrodynamic theory and Bayesian hierarchical modeling. arXiv preprint 2010.04769.
}
\seealso{
\code{\link{tournament}}
}
\keyword{internal}
