% Generated by roxygen2 (4.0.2): do not edit by hand
\name{bd2t}
\alias{bd2t}
\title{Transform \code{Date}s into your business-date scale.}
\usage{
bd2t(dates, business.dates)
}
\arguments{
\item{dates}{a \code{Date} vector for which you want to transform each date into an
integer \code{t} which is the number of business days after the first date in
your \code{business.dates} vector}

\item{business.dates}{a vector of \code{Date} objects, sorted ascending}
}
\value{
returns an integer vector where each element is the number of business days \code{t}
 after the first date in your \code{business.dates} vector
}
\description{
Transform \code{Date}s into your business-date scale.
}
\examples{
monday <- as.Date('2014-10-13')
weekdays <- monday + 0:4
bd2t(monday + c(1, 3), weekdays)
}

