% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_fcs.R
\name{transform_bead_channels}
\alias{transform_bead_channels}
\title{Transform parameters with bead events.}
\usage{
transform_bead_channels(.flow_frame, .bead_channels)
}
\arguments{
\item{.flow_frame}{A \code{flowFrame}. Usually the result of \code{read.FCS} from \code{flowCore}.}

\item{.bead_channels}{A character vector of the length of 2 with the names of the channels to transform.}
}
\value{
A \code{flowFrame} with the beads channels transformed
}
\description{
Channels with bead events are transformed using \code{flowCore}'s \code{arcsinhTransform()}.
}
\examples{
\dontrun{
library(beadplexr)
library(flowCore)
.file_name <- system.file("extdata", "K2-C07-A7.fcs",
                          package = "beadplexr")
# Load the fcs file
.flow_frame <- read.FCS(filename = .file_name,
                                 transformation = FALSE)
# Transform channels
.flow_frame <- transform_bead_channels(.flow_frame = .flow_frame,
                            .bead_channels =
                                c("FL6-H", "FL2-H"))
}
}
\seealso{
\code{\link[flowCore]{arcsinhTransform}} for the transformation.
}
\keyword{internal}
