% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_conc.R
\name{calc_std_conc}
\alias{calc_std_conc}
\title{Calculate standard concentration}
\usage{
calc_std_conc(.standard_sample, .start_concentration,
  .dilution_factor = 4L)
}
\arguments{
\item{.standard_sample}{a vector giving the standard samples. The sample with
the highest value is given the start concentration, and a
\code{.standard_sample} with the value of 0, is set to 0 if it exists. See
Details for details on how order is assessed.}

\item{.start_concentration}{a numeric vector giving the initial standard
concentration. If longer than one the maximum value is taken as start
concentration.}

\item{.dilution_factor}{a numeric vector giving the dilution factor. If a
single element is passed, this is applied to all standard samples as a
dilution series. If more then one value is given, it must be of equal
length as the \code{.standard_sample}, and each element is taken as the dilution
factor to the previous element, using 1 for the first element. The order of
dilution factors must match that of the ordered \code{.standard_sample}.}
}
\value{
A numeric vector
}
\description{
Given a start concentration and dilution factor, the concentration of the given standard samples is calculated
}
\details{
In the manuals to the LEGENDplex system, standard are labeled 0 to 8, where 8
indicate the highest concentration and 0 the background (no analyte). The standard is diluted at 1:4 so that\preformatted{[s7] = [start]
[s6] = [s7]/4
[s5] = [s6]/4
[s4] = [s5]/4
[s3] = [s4]/4
[s2] = [s3]/4
[s1] = [s2]/4
[s0] = 0
}

It might happen, that a dilution step is missing in which case the dilution
is corrected to accommodate the missing step. However, since it is inspired
guess work and out of the ordinary, a warning is thrown, see Examples.
}
\section{Standard sample order}{

If the vector is numeric, the values are ordered numerically from high to low.

If the vector is not numeric, things become a little more difficult, because
sorting a vector like \code{c("a", "c", "0", "b")} by default results in \code{c("0", "a", "b", "c")}, which means that '0' is the highest value and will be
assigned the start concentration and the sample 'a' is then the first
dilution.

To avoid this problem, the vector is split into two: one containing numerical
values and one containing alphabetical. Each vector is then sorted
appropriately and combined, see Examples.
}

\examples{

calc_std_conc(.standard_sample = c(7:0),
                                 .start_concentration = 5000)
# Sample 5 is missing
calc_std_conc(.standard_sample = c(7, 6, 4, 3, 2, 1, 0),
                                 .start_concentration = 5000)
calc_std_conc(.standard_sample = rep(c(7:0), 2),
                                 .start_concentration = 5000)
calc_std_conc(.standard_sample = c(9:0),
                                .start_concentration = 5000)

calc_std_conc(.standard_sample = c(letters[1:7], 0),
                                 .start_concentration = 5000)
calc_std_conc(.standard_sample = c(letters[1:7], 0, 1),
                                 .start_concentration = 5000)

calc_std_conc(.standard_sample = c(7:1, 0),
                                 .start_concentration = 5000,
                                 .dilution_factor = c(1, 2, 2, 2, 4, 6, 6, 0))

# If 0 exists it is always set to 0
calc_std_conc(.standard_sample = c(7:1, 0),
                                 .start_concentration = 5000,
                                 .dilution_factor = c(1, 2, 2, 2, 4, 6, 6, 100000))
calc_std_conc(.standard_sample = c(8:1),
                                 .start_concentration = 5000,
                                 .dilution_factor = c(1, 2, 2, 2, 4, 6, 6, 100000))
}
