% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/turning_points.R
\name{turning_point}
\alias{turning_point}
\title{Turning points}
\usage{
turning_point(
  .x,
  .which = c("both", "minima", "maxima"),
  .return = c("value", "index"),
  .adjust = 1.5,
  .k = NULL,
  ...
)
}
\arguments{
\item{.x}{A numeric vector or a list of numeric vectors. If the list is
named, the names become column names in the returned data.frames}

\item{.which}{A character indicating the values of interest.}

\item{.return}{A character giving the desired return type.}

\item{.adjust}{A numeric giving the adjustment to the \code{adjust} argument of \code{\link[stats:density]{stats::density()}}.}

\item{.k}{Numeric giving the number of expected clusters.}

\item{...}{
  Arguments passed on to \code{\link[=approx_adjust]{approx_adjust}}
  \describe{
    \item{\code{.lower}}{The interval for possible value of adjust.}
    \item{\code{.upper}}{The interval for possible value of adjust.}
    \item{\code{.step}}{A numeric giving the increment to adjust. Sometimes low values
are needed to find a proper adjust value.}
  }}
}
\value{
A list with the two elements \code{maxima} and \code{minima}. each element
consist of a single \code{data.frame}.
}
\description{
Find turning points (minima and maxima) in a vector.
}
\examples{

set.seed(1234)
.x <- c(rnorm(100, 2, 1), rnorm(100, 9, 1))

turning_point(.x = .x, .adjust = 1)
turning_point(.x = .x, .k = 2)

turning_point(.x = .x, .which = "minima")
turning_point(.x = .x, .which = "maxima")

turning_point(.x = .x, .return = "index")
}
