% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{listen}
\alias{listen}
\title{Listen for connections on a Beakr instance}
\usage{
listen(
  beakr = NULL,
  host = "127.0.0.1",
  port = 25118,
  daemon = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{beakr}{\code{Beakr} instance.}

\item{host}{String that is a valid IPv4 or IPv6 address to listen on.
Defaults to the local host ("127.0.0.1").}

\item{port}{Number or integer that indicates the port to listen on. Default
is a port opened on 25118.}

\item{daemon}{Logical specifying whether the server should be run in the
background.}

\item{verbose}{Logical specifying whether to print out details of the
\code{Beakr} instance now running. This should only be used when running
a beaker app interactively, not in production.}
}
\value{
A \code{Beakr} instance with an active server.
}
\description{
Binds and listens for connections at the specified host and port.
}
\details{
\code{listen()} binds the specified host and port and listens for connections
on a thread. The thread handles incoming requests. when it receives an HTTP
request, it will schedule a call to the user-defined middleware and handle the
request.

If \code{daemon = TRUE}, \code{listen()} binds the specified port and listens
for connections on a thread running in the background.

See the \pkg{httpuv} package for more details.
}
\note{
The default port number 25118 was generated using:
\preformatted{
> match(c("b","e","a","k","r"), letters) \%\% 10
[1] 2 5 1 1 8
}
}
\examples{
library(beakr)

# Create an new Beakr instance
beakr <- newBeakr()

# beakr pipeline
beakr \%>\%

  httpGET("/", function(req, res, err) {
    return("Successful GET request!\n")
  }) \%>\%

  listen(daemon = TRUE)     # run in the background

# Stop the server
stopServer(beakr)
}
