% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_default_beast2_folder.R
\name{get_default_beast2_folder}
\alias{get_default_beast2_folder}
\title{Get the path to the folder where this package installs
BEAST2 by default}
\usage{
get_default_beast2_folder()
}
\value{
the path to the folder where this package installs
  BEAST2 by default
}
\description{
Get the path to the folder where this package installs
BEAST2 by default
}
\examples{
  library(testthat)

  if (rappdirs::app_dir()$os == "unix") {
    expect_true(
      grepl(
        "/home/[A-Za-z0-9_]*/.local/share",
        get_default_beast2_folder()
      )
    )
  }
}
\seealso{
Use \link{get_default_beast2_jar_path} to get the path
  to the BEAST2 jar file, when installed by this package
  Use \link{install_beast2} with default arguments
  to install BEAST2 to this folder.
}
\author{
Richèl J.C. Bilderbeek
}
