% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_site_model.R
\name{create_hky_site_model}
\alias{create_hky_site_model}
\alias{create_site_model_hky}
\title{Create an HKY site model}
\usage{
create_hky_site_model(id = NA, kappa = "2.0",
  gamma_site_model = create_gamma_site_model(),
  kappa_prior_distr = create_log_normal_distr(m = create_m_param(value =
  "1.0"), s = create_s_param(value = "1.25")), freq_equilibrium = "estimated")
}
\arguments{
\item{id}{the IDs of the alignment (can be extracted from
the FASTA filesname using \code{\link{get_id}})}

\item{kappa}{the kappa}

\item{gamma_site_model}{a gamma site model, as created
by \code{\link{create_gamma_site_model}}}

\item{kappa_prior_distr}{the distribution of the kappa prior,
which is a log-normal distribution
(as created by \code{\link{create_log_normal_distr}})
by default}

\item{freq_equilibrium}{the frequency in which the rates are at equilibrium
are either \code{estimated}, \code{empirical} or \code{all_equal}.
\code{\link{get_freq_equilibrium_names}} returns the possible values
for \code{freq_equilibrium}}
}
\value{
an HKY site_model
}
\description{
Create an HKY site model
}
\examples{
 hky_site_model <- create_hky_site_model()

 create_beast2_input_file(
   input_filenames = get_fasta_filename(),
   "beast.xml",
   site_models = hky_site_model
 )
}
\author{
Richel J.C. Bilderbeek
}
