% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tree_prior_n_params.R
\name{get_tree_prior_n_params}
\alias{get_tree_prior_n_params}
\title{Get the number of parameters a tree prior has}
\usage{
get_tree_prior_n_params(tree_prior)
}
\arguments{
\item{tree_prior}{a tree_prior,
as created by \code{\link{create_tree_prior}}}
}
\value{
the number of parameters a tree prior has
}
\description{
Get the number of parameters a tree prior has
}
\examples{
 # birth_rate_distr is uniform, which has zero parameters
 # death_rate_distr is uniform, which has zero parameters
 testit::assert(
   get_tree_prior_n_params(create_bd_tree_prior()) == 0
 )

 # no distributions, no parameters
 testit::assert(
   get_tree_prior_n_params(create_cbs_tree_prior()) == 0
 )

 # pop_size_distr is 1/x, which has zero parameters
 testit::assert(
   get_tree_prior_n_params(create_ccp_tree_prior()) == 0
 )

 # pop_size_distr is 1/x, which has zero parameters
 # growth_rate_distr is Laplace, which has two parameters
 testit::assert(
   get_tree_prior_n_params(create_cep_tree_prior()) == 2
 )

 # birth_rate_distr is uniform, which has zero parameters
 testit::assert(
   get_tree_prior_n_params(create_yule_tree_prior()) == 0
 )
}
\author{
Richèl J.C. Bilderbeek
}
