% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_tree_prior_n_params.R
\name{get_tree_prior_n_params}
\alias{get_tree_prior_n_params}
\title{Get the number of parameters a tree prior has}
\usage{
get_tree_prior_n_params(tree_prior)
}
\arguments{
\item{tree_prior}{a tree_prior,
as created by \code{\link{create_tree_prior}}}
}
\value{
the number of parameters a tree prior has
}
\description{
Get the number of parameters a tree prior has
}
\examples{
check_empty_beautier_folder()

# birth_rate_distr is uniform, which has zero parameters
# death_rate_distr is uniform, which has zero parameters
get_tree_prior_n_params(create_bd_tree_prior())

# no distributions, no parameters
get_tree_prior_n_params(create_cbs_tree_prior())

# pop_size_distr is 1/x, which has zero parameters
get_tree_prior_n_params(create_ccp_tree_prior())

# pop_size_distr is 1/x, which has zero parameters
# growth_rate_distr is Laplace, which has two parameters
get_tree_prior_n_params(create_cep_tree_prior())

# birth_rate_distr is uniform, which has zero parameters
get_tree_prior_n_params(create_yule_tree_prior())

check_empty_beautier_folder()
}
\author{
Richèl J.C. Bilderbeek
}
