% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_mcmc_filenames.R
\name{get_mcmc_filenames}
\alias{get_mcmc_filenames}
\title{Get the filenames stored in an MCMC.}
\usage{
get_mcmc_filenames(mcmc)
}
\arguments{
\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}
}
\description{
If a filename is set to an empty string, to indicate a certain log file
need not be created, this (non-)filename will not be returned.
}
\examples{
check_empty_beautier_folder()

mcmc <- create_mcmc()
mcmc$tracelog$filename <- "/home/john/trace.log"
mcmc$screenlog$filename <- "/home/john/screen.log"
mcmc$treelog$filename <- "/home/john/tree.log"

# 3 filenames
filenames <- get_mcmc_filenames(mcmc)

# If there is no need to write to the screenlog file ...
mcmc$screenlog$filename <- ""

# 2 filenames
# ... one file less will be created
filenames <- get_mcmc_filenames(mcmc)

check_empty_beautier_folder()
}
