% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_distr.R
\name{create_beast2_input_distr}
\alias{create_beast2_input_distr}
\title{Creates the distribution section of a BEAST2 XML parameter file.}
\usage{
create_beast2_input_distr(
  inference_model,
  site_models = "deprecated",
  clock_models = "deprecated",
  tree_priors = "deprecated",
  mrca_priors = "deprecated",
  tipdates_filename = "deprecated"
)
}
\arguments{
\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}

\item{site_models}{one or more site models,
as returned by \code{\link{create_site_model}}}

\item{clock_models}{a list of one or more clock models,
as returned by \code{\link{create_clock_model}}}

\item{tree_priors}{one or more tree priors,
as returned by \code{\link{create_tree_prior}}}

\item{mrca_priors}{a list of one or more Most Recent Common Ancestor priors,
as returned by \code{\link{create_mrca_prior}}}

\item{tipdates_filename}{name of the file containing the tip dates.
This file is assumed to have two columns, separated by a tab.
The first column contains the taxa names, the second column contains
the date.}
}
\value{
lines of XML text
}
\description{
Creates the distribution section of a BEAST2 XML parameter file.
}
\note{
this function is not intended for regular use, thus its
  long name length is accepted
}
\examples{
 # <distribution id="posterior" spec="util.CompoundDistribution">
 #     <distribution id="prior" spec="util.CompoundDistribution">
 #       HERE, where the ID of the distribution is 'prior'
 #     </distribution>
 #     <distribution id="likelihood" ...>
 #     </distribution>
 # </distribution>
}
\seealso{
\code{\link{create_beast2_input}}
}
\author{
Richèl J.C. Bilderbeek
}
