% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abcd.R
\docType{data}
\name{abcd_specs_examples}
\alias{abcd_specs_examples}
\alias{abcd_specs_full}
\alias{abcd_specs_single_po}
\title{Two simple example datasets for ABCD's}
\format{For \code{abcd_specs_full}, a data frame with 6 variables and 7 rows;
for \code{abcd_specs_single_po}, a data frame with 5 variables and 4 rows.}
\usage{
data(abcd_specs_full)
}
\description{
This are two (nested) datasets illustrating the logic model of change for
a simple condom use intervention in a way that can be visualised using
the \link{abcd} function. The full dataset is \code{abcd_specs_full}, and a subset
that only contains the information about one sub-behavior (performance
objective) is available as \code{abcd_specs_single_po}. The variables in the full
dataset are:
}
\details{
\itemize{
\item \code{Behavior Change Principles}: The behavior change principles (BCPs), also known as methods for behavior change or 'behavior change techniques' (BCTs), that describe the psychological principles that are assumed to realise the change in the (sub-)determinants.
\item \code{Applications}: The applications of these BCPs. Where the BCPs describe theoretical principles, the applications are more or less tangible intervention elements.
\item \code{Sub-determinants\\n(e.g. beliefs; can be formulated as Change Objectives)}: The specific aspects of teh target population's psychology that are targeted by the BCPs (e.g. beliefs, or in Intervention Mapping vocabulary, Change Objectives).
\item \code{Determinants}: The determinants, psychological constructs, that the targeted sub-determinants are a part of, and that together predict the Performance Objectives (sub-behaviors).
\item \code{Performance Objectives}: Explicitly defined sub-behaviors at a level of specificity that distinguishes them from other sub-behaviors, and that together form the target behavior.
\item \code{Target Behavior}: The ultimate target behavior, usually defined at a relatively general level.
}
}
\keyword{data}
