% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workout.R
\name{workout}
\alias{workout}
\alias{workout_expressions}
\title{Workout a group of expressions individually}
\usage{
workout(expr, description = NULL)

workout_expressions(exprs, env = parent.frame(), description = NULL)
}
\arguments{
\item{expr}{one or more expressions to workout, use \code{{}} to pass multiple
expressions.}

\item{description}{A name to label each expression, if not supplied the
deparsed expression will be used.}

\item{exprs}{A list of calls to measure.}

\item{env}{The environment in which the expressions should be evaluated.}
}
\description{
Given an block of expressions in \code{{}} \code{\link[=workout]{workout()}} individually times each
expression in the group. \code{\link[=workout_expressions]{workout_expressions()}} is a lower level function most
useful when reading lists of calls from a file.
}
\examples{
workout({
  x <- 1:1000
  evens <- x \%\% 2 == 0
  y <- x[evens]
  length(y)
  length(which(evens))
  sum(evens)
})

# The equivalent to the above, reading the code from a file
workout_expressions(as.list(parse(system.file("examples/exprs.R", package = "bench"))))
}
