% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-beta-mc.R
\name{BetaMC}
\alias{BetaMC}
\title{Estimate Standardized Regression Coefficients
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method}
\usage{
BetaMC(object)
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}
}
\value{
Returns an object
of class \code{betamc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{object}{The function argument \code{object}.}
\item{thetahatstar}{Sampling distribution of
\eqn{\boldsymbol{\hat{\beta}}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{\boldsymbol{\hat{\beta}}}.}
\item{est}{Vector of estimated
\eqn{\boldsymbol{\hat{\beta}}}.}
\item{fun}{Function used ("BetaMC").}
}
}
\description{
Estimate Standardized Regression Coefficients
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method
}
\details{
The vector of standardized regression coefficients
(\eqn{\boldsymbol{\hat{\beta}}})
is derived from each randomly generated vector of parameter estimates.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{\boldsymbol{\hat{\beta}}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Fit the regression model
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)
# Generate the sampling distribution of parameter estimates
# (use a large R, for example, R = 20000 for actual research)
mc <- MC(object, R = 100)
# Generate confidence intervals for standardized regression slopes
std <- BetaMC(mc)
# Methods --------------------------------------------------------
print(std)
summary(std)
coef(std)
vcov(std)
confint(std, level = 0.95)
}
\seealso{
Other Beta Monte Carlo Functions: 
\code{\link{DeltaRSqMC}()},
\code{\link{DiffBetaMC}()},
\code{\link{MC}()},
\code{\link{PCorMC}()},
\code{\link{RSqMC}()},
\code{\link{SCorMC}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Monte Carlo Functions}
\keyword{betaMC}
\keyword{std}
