% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgg_tools.R
\name{bgg_namestyle}
\alias{bgg_namestyle}
\title{Detect the namestyle of the data table}
\usage{
bgg_namestyle(dt)
}
\arguments{
\item{dt}{a data.table from \code{data} slot of a \code{bggAPI} object.}
}
\value{
A single string.
}
\description{
Detects whether the \code{dt} data.table was created by a \code{bggAPI}
object with \code{'pretty'} or \code{'classic'} names. Ends with the error if
one of them cannot be unequivocally determined. This can be useful when
working on a modified table that is no longer directly connected to any
\code{bggAPI} object.
}
\examples{
gm <- bggGames$new(ids = 167791)
bgg_namestyle(gm$data)

gm$switch_namestyle("pretty")
bgg_namestyle(gm$data)

# Breaks
# bgg_namestyle(iris)

}
\author{
Jakub Bujnowicz \email{bujnowiczgithub@gmail.com}
}
