% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampleMRF.R
\name{mrfSampler}
\alias{mrfSampler}
\title{Sample states of the ordinal MRF}
\usage{
mrfSampler(
  no_states,
  no_nodes,
  no_categories,
  interactions,
  thresholds,
  iter = 1000
)
}
\arguments{
\item{no_states}{The number of states of the ordinal MRF to be generated.}

\item{no_nodes}{The number of nodes in the ordinal MRF.}

\item{no_categories}{Either a positive integer or a vector of positive
integers of length \code{no_nodes}. The number of response categories on top
of the base category: \code{no_categories = 1} generates binary states.}

\item{interactions}{A symmetric \code{no_nodes} by \code{no_nodes} matrix of
pairwise interactions. Only its off-diagonal elements are used.}

\item{thresholds}{A \code{no_nodes} by \code{max(no_categories)} matrix of
category thresholds. The elements in row \code{r} indicate the thresholds of
node \code{r}. If \code{no_categories} is a vector, only the first
\code{no_categories[r]} elements are used in row \code{r}.}

\item{iter}{The number of iterations used by the Gibbs sampler.
The function provides the last state of the Gibbs sampler as output. By
default set to \code{1e3}.}
}
\value{
A \code{no_states} by \code{no_nodes} matrix of simulated states of
the ordinal MRF.
}
\description{
This function samples states from the ordinal MRF using a Gibbs sampler. The
Gibbs sampler is initiated with random values from the response options,
after which it proceeds by simulating states for each node from a logistic
model using the other node states as predictor variables.
}
\examples{
# Generate responses from a network of five binary and ordinal variables.
no_nodes = 5
no_categories = sample(1:5, size = no_nodes, replace = TRUE)

Interactions = matrix(0, nrow = no_nodes, ncol = no_nodes)
Interactions[2, 1] = Interactions[4, 1] = Interactions[3, 2] =
  Interactions[5, 2] = Interactions[5, 4] = .25
Interactions = Interactions + t(Interactions)
Thresholds = matrix(0, nrow = no_nodes, ncol = max(no_categories))
x = mrfSampler(no_states = 1e3,
               no_nodes = no_nodes,
               no_categories = no_categories,
               interactions = Interactions,
               thresholds = Thresholds)
}
