% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OCFunctions.R
\name{getGoProbabilities}
\alias{getGoProbabilities}
\title{getGoProbabilities}
\usage{
getGoProbabilities(go_decisions_list, nogo_decisions_list = NULL)
}
\arguments{
\item{go_decisions_list}{An object of class \code{decision_list},
as returned by \code{\link[bhmbasket]{getGoDecisions}}}

\item{nogo_decisions_list}{An object of class \code{decision_list},
as returned by \code{\link[bhmbasket]{getGoDecisions}}, Default: \code{NULL}}
}
\value{
A list of matrices of Go (and Consider and NoGo) probabilities
}
\description{
Calculates the Go probabilities for given decisions
}
\details{
If only \code{go_decisions_list} is provided
(i.e. \code{nogo_decisions_list} is \code{NULL}),
only Go probabilities will be calculated.
If both \code{go_decisions_list} and \code{nogo_decisions_list} are provided,
Go, Consider, and NoGo probabilities will be calculated.
}
\examples{
scenarios_list <- simulateScenarios(
  n_subjects_list     = list(c(10, 20)),
  response_rates_list = list(rep(0.9, 2)),
  n_trials            = 10)

analyses_list <- performAnalyses(
  scenario_list       = scenarios_list,
  target_rates        = rep(0.5, 2),
  n_mcmc_iterations   = 100,
  n_cores             = 1L)

go_decisions_list <- getGoDecisions(
  analyses_list       = analyses_list,
  cohort_names        = c("p_1", "p_2"),
  evidence_levels     = c(0.5, 0.8),
  boundary_rules      = quote(c(x[1] > 0.8, x[2] > 0.6)))

nogo_decisions_list <- getGoDecisions(
  analyses_list       = analyses_list,
  cohort_names        = c("p_1", "p_2"),
  evidence_levels     = c(0.5, 0.8),
  boundary_rules      = quote(c(x[1] < 0.5, x[2] < 0.3)))

getGoProbabilities(go_decisions_list)
getGoProbabilities(go_decisions_list, nogo_decisions_list)
}
\seealso{
\code{\link[bhmbasket]{getGoDecisions}}
}
\author{
Stephan Wojciekowski
}
