% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataFunctions.R
\name{loadScenarios}
\alias{loadScenarios}
\title{loadScenarios}
\usage{
loadScenarios(scenario_numbers, load_path = tempdir())
}
\arguments{
\item{scenario_numbers}{A vector of integers naming the scenario to be loaded}

\item{load_path}{A string for the directory where the scenarios are being stored,
Default: \code{\link[base]{tempfile}}}
}
\value{
Returns an object of class \code{scenario_list}
}
\description{
This function loads scenarios saved with \code{\link[bhmbasket]{saveScenarios}}
}
\examples{
  scenarios_list <- simulateScenarios(
    n_subjects_list     = list(c(10, 20, 30)),
    response_rates_list = list(rep(0.9, 3)),
    n_trials            = 10)

  save_info      <- saveScenarios(scenarios_list)
  scenarios_list <- loadScenarios(scenario_numbers = save_info$scenario_numbers,
                                  load_path        = save_info$path)
}
\seealso{
\code{\link[bhmbasket]{simulateScenarios}}
\code{\link[bhmbasket]{saveScenarios}}
\code{\link[base]{tempfile}}
}
\author{
Stephan Wojciekowski
}
