% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PriorFunctions.R
\name{getMuVar}
\alias{getMuVar}
\title{getMuVar}
\usage{
getMuVar(response_rate, tau_scale, n_worth = 1)
}
\arguments{
\item{response_rate}{A numeric for the response rate}

\item{tau_scale}{A numeric for the scale parameter of the Half-normal distribution of \eqn{\tau}}

\item{n_worth}{An integer for the number of subjects the variance of \eqn{\mu} should be worth
with regard to the variability of the distribution of the response rate, Default: \code{1}}
}
\value{
Returns a numeric for the variance of \eqn{\mu}
}
\description{
This function returns the variance of \eqn{\mu} that is worth a certain number
of subjects for the distribution of the response rates.
}
\details{
Calculates the variance \code{mu_var} in
\deqn{logit(p) = \theta ~ N(\mu, \tau),
\mu ~ N(mu_mean, mu_var), \tau ~ HN(tau_scale),}
for \code{n_worth} number of observations, as in Neuenschwander et al. (2016).
}
\examples{
  getMuVar(response_rate = 0.3,
           tau_scale     = 1)
  getMuVar(response_rate = 0.3,
           tau_scale     = 1,
           n_worth       = 2)
}
\references{
Neuenschwander, Beat, et al. "Robust exchangeability designs
for early phase clinical trials with multiple strata."
\emph{Pharmaceutical statistics} 15.2 (2016): 123-134.
}
\author{
Stephan Wojciekowski
}
