% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wrappers.R
\name{KOS}
\alias{KOS}
\title{Function which generates feature weights, discriminant vector, and class predictions.}
\usage{
KOS(TestData = NULL, TrainData, TrainCat, Method = "Full",
  Mode = "Automatic", m1 = NULL, m2 = NULL, s = NULL,
  Sigma = NULL, Gamma = NULL, Lambda = NULL, Epsilon = 1e-05)
}
\arguments{
\item{TestData}{(m x p) Matrix of unlabelled data with numeric features to be classified. Cannot have missing values.}

\item{TrainData}{(n x p) Matrix of training data with numeric features. Cannot have missing values.}

\item{TrainCat}{(n x 1) Vector of class membership corresponding to Data. Values must be either 1 or 2.}

\item{Method}{A string of characters which determines which version of KOS to use. Must be either "Full" or "Subsampled". Default is "Full".}

\item{Mode}{A string of characters which determines how the reduced sample paramters will be inputted for each method. Must be either "Research", "Interactive", or "Automatic". Default is "Automatic".}

\item{m1}{The number of class 1 compressed samples to be generated. Must be a positive integer.}

\item{m2}{The number of class 2 compressed samples to be generated. Must be a positive integer.}

\item{s}{The sparsity level used in compression. Must satify 0 < s < 1.}

\item{Sigma}{Scalar Gaussian kernel parameter. Default set to NULL and is automatically generated if user-specified value not provided. Must be > 0. User-specified parameters must satisfy hierarchical ordering.}

\item{Gamma}{Scalar ridge parameter used in kernel optimal scoring. Default set to NULL and is automatically generated if user-specified value not provided. Must be > 0. User-specified parameters must satisfy hierarchical ordering.}

\item{Lambda}{Scalar sparsity parameter on weight vector. Default set to NULL and is automatically generated by the function if user-specified value not provided. Must be >= 0. When Lambda = 0, SparseKOS defaults to kernel optimal scoring of [Lapanowski and Gaynanova, preprint] without sparse feature selection. User-specified parameters must satisfy hierarchical ordering.}

\item{Epsilon}{Numerical stability constant with default value 1e-05. Must be > 0 and is typically chosen to be small.}
}
\value{
A list of
\item{Predictions}{ (m x 1) Vector of predicted class labels for the data points in TestData. Only included in non-null value of X is provided.} 
\item{Weights}{ (p x 1) Vector of feature weights.} 
\item{Dvec}{(n x 1) Discrimiant coefficients vector.}
}
\description{
Returns a (m x 1) vector of predicted group membership (either 1 or 2) for each data point in X. Uses Data and Cat to train the classifier.
}
\details{
Function which handles classification. Generates feature weight vector and discriminant coefficients vector in sparse kernel optimal scoring. If a matrix X is provided, the function classifies each data point using the generated feature weight vector and discriminant vector. Will use user-supplied parameters Sigma, Gamma, and Lambda if any are given. If any are missing, the function will run SelectParams to generate the other parameters. User-specified values must satisfy hierarchical ordering.
}
\examples{
\donttest{
Sigma <- 1.325386  #Set parameter values equal to result of SelectParam.
Gamma <- 0.07531579 #Speeds up example.
Lambda <- 0.002855275

TrainData <- KOS_Data$TrainData
TrainCat <- KOS_Data$TrainCat
TestData <- KOS_Data$TestData
TestCat <- KOS_Data$TestCat

KOS(TestData = TestData, 
    TrainData = TrainData, 
    TrainCat = TrainCat , 
    Sigma = Sigma , 
    Gamma = Gamma , 
    Lambda = Lambda)
}
}
\references{
Lapanowski, Alexander F., and Gaynanova, Irina. ``Sparse feature selection in kernel discriminant analysis via optimal scoring'', Artificial Intelligence and Statistics, 2019.
}
