% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather.biclustermd.R
\name{gather.biclustermd}
\alias{gather.biclustermd}
\title{Gather a biclustermd object}
\usage{
\method{gather}{biclustermd}(
  data,
  key = NULL,
  value = NULL,
  ...,
  na.rm = FALSE,
  convert = FALSE,
  factor_key = FALSE
)
}
\arguments{
\item{data}{a \code{biclustermd} object to gather.}

\item{key}{unused; included for consistency with \code{tidyr} generic}

\item{value}{unused; included for consistency with \code{tidyr} generic}

\item{...}{unused; included for consistency with \code{tidyr} generic}

\item{na.rm}{unused; included for consistency with \code{tidyr} generic}

\item{convert}{unused; included for consistency with \code{tidyr} generic}

\item{factor_key}{unused; included for consistency with \code{tidyr} generic}
}
\value{
A data frame containing the row names and column names of both the
two-way table of data biclustered and the cell-average matrix.
}
\description{
Gather a biclustermd object
}
\examples{
data("synthetic")

bc <- biclustermd(synthetic, col_clusters = 3, row_clusters = 2,
                miss_val = mean(synthetic, na.rm = TRUE),
                miss_val_sd = sd(synthetic, na.rm = TRUE),
                col_min_num = 2, row_min_num = 2,
                col_num_to_move = 1, row_num_to_move = 1,
                max.iter = 10)
gather(bc)

# bicluster 6 is in the top right-hand corner here:
autoplot(bc)

# bicluster 3 is in the bottom right-hand corner here:
autoplot(bc)

}
