% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa-generics-as_bids_tabular.R,
%   R/class030-bids_dataset_description.R
\name{get_bids_dataset_description}
\alias{get_bids_dataset_description}
\alias{BIDSDatasetDescription}
\title{Class definition of 'BIDS' data-set description}
\usage{
get_bids_dataset_description(x, parent_directory, ...)

BIDSDatasetDescription(
  Name = character(0),
  BIDSVersion = character(0),
  DatasetLinks = list(),
  HEDVersion = character(0),
  DatasetType = character(0),
  License = character(0),
  Authors = character(0),
  GeneratedBy = list(),
  SourceDatasets = list(),
  Acknowledgements = character(0),
  HowToAcknowledge = character(0),
  Funding = character(0),
  EthicsApprovals = character(0),
  ReferencesAndLinks = character(0),
  DatasetDOI = character(0),
  parent_directory = character(0)
)
}
\arguments{
\item{x}{R object to be interpreted as 'BIDS' data description; default
support list, path to the \code{'json'} file, \code{'json'} string, etc.}

\item{parent_directory}{parent directory where the file
\code{'dataset_description.json'} is stored. This input is ignored
if \code{x} is the path to \code{'dataset_description.json'}, otherwise
is a must.}

\item{...}{passed to methods}

\item{Name}{(required, string) Name of the data-set.}

\item{BIDSVersion}{(required, string) The version of the BIDS standard that
was used.}

\item{DatasetLinks}{(required if 'BIDS-URI' is used) Used to map a given
data-set name from a 'BIDS-URI' of the form
\code{bids:<dataset-name>:path/within/dataset} to a local or remote location.}

\item{HEDVersion}{(recommended strings) The version of the 'HED' schema
used to validate 'HED' tags for study. May include a single schema or a
base schema and one or more library schema.}

\item{DatasetType}{(recommended string) Must be one of \code{"raw"} or
\code{"derivative"}; package \code{bidsr} automatically assigns
\code{"raw"} is not given.}

\item{License}{(recommended string) The license for the data-set}

\item{Authors}{(recommended strings) Vector of individuals who contributed
to the creation/curation of the data-set}

\item{GeneratedBy}{(recommended) will be converted to
\code{\link{BIDSDatasetGeneratedBy}}}

\item{SourceDatasets}{Used to specify the locations and relevant
attributes of all source data-sets. Valid keys in each object include
\code{"URL"}, \code{"DOI"}, and \code{"Version"} with string values;
Package \code{bidsr} does not check the names}

\item{Acknowledgements}{(optional string) Text acknowledging contributions
of individuals or institutions beyond those listed in Authors or Funding.}

\item{HowToAcknowledge}{(optional string) Text containing instructions on
how researchers using this dataset should acknowledge the original authors.
This field can also be used to define a publication that should be cited
in publications that use the dataset.}

\item{Funding}{(optional strings) List of sources of funding (grant numbers).}

\item{EthicsApprovals}{(optional strings) List of ethics committee
approvals of the research protocols and/or protocol identifiers.}

\item{ReferencesAndLinks}{(optional strings) List of references to
publications that contain information on the data-set. A reference may be
textual or a URI.}

\item{DatasetDOI}{(optional string) The Digital Object Identifier of the
data-set (not the corresponding paper). \code{'DOIs'} should be expressed
as a valid 'URI'}
}
\value{
A \code{S7} description object that contains all the fields
describing the data set; see 'Examples' for usages.
}
\description{
See \url{https://bids-specification.readthedocs.io/en/stable/modality-agnostic-files.html#dataset_descriptionjson}
for specification.
}
\examples{

# ---- Manually enter entries ----------------------------------------
dataset_description <- BIDSDatasetDescription(
  # a parent directory is mandatory as it defines what data
  # dataset_description.json applies to

  parent_directory = "/path/to/BIDS/folder",

  Name = "A dummy experiments",
  BIDSVersion = "1.6.0",
  License = "CC0",
  Authors = c("Zhengjia Wang"),
  Acknowledgements = c(
    "Package `bidsr` is a 3rd-party BIDS reader developed by",
    "a RAVE (https://rave.wiki) team member with procrastination."
  ),
  HowToAcknowledge = c(
    "Please cite this paper:",
    "https://doi.org/10.1016/j.neuroimage.2020.117341"
  ),
  Funding = c(
    "NIH R01MH133717",
    "NIH U01NS113339",
    "NIH 1R24MH117529"
  ),
  ReferencesAndLinks = c(
    "https://rave.wiki"
  ),
  DatasetDOI = "https://doi.org/10.1016/j.neuroimage.2020.117341",
  HEDVersion = "8.0.0",
  GeneratedBy = list(
    list(
      Name = "Dipterix",
      Version = "0.0.1",
      Container = list(
        Type = "r-package",
        Tag = "dipterix/bidsr:0.0.1"
      )
    )
  )
)

# access the information
dataset_description$License

dataset_description$GeneratedBy[[1]]$Container

# ---- Read from file ---------------------------------------------

# Run `download_bids_examples()` first
examples <- download_bids_examples(test = TRUE)
if(!isFALSE(examples)) {
  example_descr <- file.path(
    examples, "ieeg_epilepsy_ecog", "dataset_description.json")

  x <- get_bids_dataset_description(example_descr)
  x

  # ---- Formatting --------------------------------------------------
  # convert to R list (use recursive to expand field `GeneratedBy`)
  as.list(x, recursive = TRUE)

  # JSON string
  format(x)
}

}
\author{
Zhengjia Wang
}
