% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfa.boot.ls.bc.R
\name{bfa.boot.ls.bc}
\alias{bfa.boot.ls.bc}
\title{Bootstrap of Bias-Correction Least Squares Estimators of BAR(p) Models}
\usage{
bfa.boot.ls.bc(
  z,
  p,
  method = "boot1",
  burn = 5,
  B,
  boot.est = TRUE,
  boot.data = FALSE
)
}
\arguments{
\item{z}{a numeric vector containing the tree data}

\item{p}{an integer determining the order of bifurcating autoregressive model
to be fit to the data}

\item{method}{method of bias correction. Currently, "boot1", "boot2",
"boot2fast" and "LBC" are supported and they implement single bootstrap,
double bootstrap, fast-double bootstrap, and linear-bias-function
bias-correction, respectively.}

\item{burn}{number of tree generations to discard before starting the
bootstrap sample (replicate)}

\item{B}{number of bootstrap samples (replicates)}

\item{boot.est}{a logical that determines whether the bootstrapped least
squares estimates of the autoregressive coefficients should be returned.
Defaults to TRUE.}

\item{boot.data}{a logical that determines whether the bootstrap samples
should be returned. Defaults to FALSE.}
}
\value{
\item{boot.bcest}{a matrix containing the bootstrapped bias-correction
least squares estimates of the autoregressive coefficients} \item{boot.data}{a matrix
containing the bootstrap samples used}
}
\description{
This function performs linear-bias-function bias-correction (LBC), single
bootstrap, double bootstrap, fast-double bootstrap of the bias-correction
least squares estimators of the autoregressive coefficients in a bifurcating
autoregressive (BAR) model of any order \code{p} as described in Elbayoumi &
Mostafa (2020).
}
\examples{
z <- bfa.tree.gen(31, 1, 1, 1, 0.5, 0.5, 0, 10, c(0.7))
bfa.boot.ls.bc(z, p=1, method="LBC", B=500)
hist(bfa.boot.ls.bc(z, p=1, method="LBC", B=500)$boot.bcest)
}
\references{
Elbayoumi, T. M. & Mostafa, S. A. (2020). On the estimation bias
in bifurcating autoregressive models. \emph{Stat}, 1-16.
}
