% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_neighbour.R
\name{add_neighbour}
\alias{add_neighbour}
\title{Add isolated areas (polygons) to its nearest neighbour}
\usage{
add_neighbour(carto, nb = NULL, plot = FALSE)
}
\arguments{
\item{carto}{object of class \code{SpatialPolygonsDataFrame} or \code{sf}.}

\item{nb}{optional argument with the neighbour list of class \code{nb}.
If \code{NULL} (default), this object is computed from the \code{carto} argument.}

\item{plot}{logical value (default \code{FALSE}), if \code{TRUE} then the computed neighbourhood graph is plotted.}
}
\value{
This function returns a list with the following two elements:
\itemize{
  \item \code{nb}: the modified neighbours's list
  \item \code{W}: associated spatial adjacency matrix of class \code{CsparseMatrix}
}
}
\description{
The function returns a neighbour list of class \code{nb} and its associated spatial adjacency matrix
computed by adding isolated areas to its nearest neighbour (in terms of Euclidean distance between centroids) using the \code{knearneigh} function of 'spdep' package.
}
\examples{
library(spdep)

## Load the Spanish colorectal cancer mortality data ##
data(Carto_SpainMUN)

## Compute the neighbour list from spatial polygons ##
nb_SpainMUN <- poly2nb(Carto_SpainMUN)
summary(nb_SpainMUN) # 1 region with no links

## Add isolated area to its nearest neighbour ####
carto.mod <- add_neighbour(carto=Carto_SpainMUN, nb=nb_SpainMUN)
summary(carto.mod$nb) # 0 region with no links

}
