% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigKRLS.R
\name{summary.bigKRLS}
\alias{summary.bigKRLS}
\title{summary.bigKRLS}
\usage{
\method{summary}{bigKRLS}(object, degrees = "Neffective", probs = c(0.05,
  0.25, 0.5, 0.75, 0.95), digits = 4, labs = NULL, ...)
}
\arguments{
\item{object}{bigKRLS output. If you saved with save.bigKRLS(), only the .RData file is needed for this function.}

\item{degrees}{"Neffective" (default) or "N". What value should be used as the sample size for the t-tests of the the AMEs (average marginal effects)? If 'Neffective' (default), degrees of freedom for t tests reflects degrees of freedom used to obtain regularization parameter, lambda. Neffective = N - sum(eigenvalues/(eigenvalues + lambda)); see e.g. Hastie et al. (2015, 61-68). 'N' is simply the observed sample size (note this is the default for library(KRLS)). Degrees of freedom for t-tests is either Neffective - P or N - P.}

\item{probs}{For quantiles of the marginal effects of each x variable.}

\item{digits}{Number of signficant digits.}

\item{labs}{Optional vector of x labels.}

\item{...}{ignore}
}
\description{
Summary function for bigKRLS output. Call knitr::kable(summary(my_ouput)[["ttests"]]) or knitr::kable(summary(my_ouput)[["percentiles"]]) to format with RNotebook or RMarkdown.
}
