% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.pgn.ff.R
\name{read.pgn.ff}
\alias{read.pgn.ff}
\title{Reads PGN files into ff data frame}
\usage{
read.pgn.ff(con, batch.size = 10^6, ignore.other.games = F, ...)
}
\arguments{
\item{con}{connection argument passed directly to readLines() function. String - the name of the file which the data are to be read from or connection object or URL.}

\item{batch.size}{number of lines to read in one batch, default is 10^6.}

\item{ignore.other.games}{boolean (default FALSE) if TRUE result is subset of original dataset without games with result marked as "*", i.e. ongoing games. The only one argument which is not passed directly to read.pgn function.}

\item{...}{further arguments passed directly to read.pgn() function (besides ignore.other.games and big.mode)}
}
\value{
ff data frame like from read.pgn() function. Since character values are not supported in ffdf object, "Movetext" column is ommited.
}
\description{
Reads PGN files into ff data frame
}
\examples{
require(ff)
require(ffbase)
f <- system.file("extdata", "Carlsen.gz", package = "bigchess")
con <- gzfile(f,"rbt",encoding = "latin1")
# options("fftempdir"="/path/"...) # if necessarily
fdf <- read.pgn.ff(con,stat.moves = FALSE)
delete(fdf)
# Works with all types of connections (also gz or zip files).
# con argument is passed directly to readLines(con,batch.size)
# so (if total number of lines to read is greater then batch.size)
# depending on platform use it correctly:
\donttest{
# Windows ('rb' opening mode for loop over readLines):
con <- gzfile(system.file("extdata", "Carlsen.gz", package = "bigchess"),"rb",encoding = "latin1")
# con <- file("path_to_big_chess_file.pgn","rb",encoding = "latin1")
fdf <- read.pgn.ff(con)
delete(fdf)}
\donttest{
# Linux/Mac OS X ('r' opening mode for loop over readLines):
con <- gzfile(system.file("extdata", "Carlsen.gz", package = "bigchess"),"r",encoding = "latin1")
# con <- file("path_to_big_chess_file.pgn","r",encoding = "latin1")
fdf <- read.pgn.ff(con)
delete(fdf)}
\donttest{
# Windows (example of zipped file handling)
unzf <- unzip("zipped_pgn_file.zip")
fdf <- read.pgn.ff(file(unzf,"rb"))
delete(fdf)
}
}
