% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_balance.r
\name{isothermal.Rn}
\alias{isothermal.Rn}
\title{Isothermal Net Radiation}
\usage{
isothermal.Rn(data, Rn = "Rn", Tair = "Tair", Tsurf = "Tsurf", emissivity,
  constants = bigleaf.constants())
}
\arguments{
\item{data}{Data.frame or matrix containing all required variables}

\item{Rn}{Net radiation (W m-2)}

\item{Tair}{Air temperature (degC)}

\item{Tsurf}{Surface temperature (degC)}

\item{emissivity}{Emissivity of the surface (-)}

\item{constants}{sigma - Stefan-Boltzmann constant (W m-2 K-4) \cr
Kelvin - conversion degree Celsius to Kelvin}
}
\value{
\item{Rni -}{isothermal net radiation (W m-2)}
}
\description{
Calculates the isothermal net radiation, i.e. the net radiation 
             that the surface would receive if it had the same temperature than
             the air.
}
\details{
The isothermal net radiation (Rni) is given by:
         
           \deqn{Rni = Rn + \epsilon * \sigma * (Tsurf^4 - Tair^4)}
         
         where \eqn{\epsilon} is the emissivity of the surface. Tsurf and Tair
         are in Kelvin.
}
\examples{
# calculate isothermal net radiation of a surface that is 2degC warmer than the air.
isothermal.Rn(Rn=400,Tair=25,Tsurf=27,emissivity=0.98) 

}
\references{
Jones, H. 2014: Plants and Microclimate. 3rd edition, Cambridge
            University Press.
}
