% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigpca.R
\name{clear_active_bms}
\alias{clear_active_bms}
\title{Function to clear big.matrix objects in the calling environment}
\usage{
clear_active_bms(ignore.os = FALSE, verbose = TRUE, only.culprits = TRUE,
  list.only = FALSE)
}
\arguments{
\item{ignore.os}{delete big.matrix objects even if the OS is not windows}

\item{verbose}{report the names of deleted matrices}

\item{only.culprits}{delete only matrices named: "bM","bM2","bmat","bmat2","tbM","sel","lmat"}

\item{list.only}{just list active big.matrix objects rather than delete them}
}
\value{
No return value, but effect is to delete the big.matrix objects in the calling env.
}
\description{
New big.memory behavious prevents overwriting of previous big.matrix
backing files, and in particular for windows you can only delete the 
backing file if the object is also deleted. This finds any big.matrix
objects in memory and deletes them (by default only with names in the
'culprits' list)
}
\examples{
clear_active_bms(ignore.os=TRUE, only.culprits=FALSE, list.only=TRUE) # list those in memory
}
