% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FBM-copy.R
\name{big_copy}
\alias{big_copy}
\title{Copy a Filebacked Big Matrix}
\usage{
big_copy(
  X,
  ind.row = rows_along(X),
  ind.col = cols_along(X),
  type = typeof(X),
  backingfile = tempfile(),
  block.size = block_size(length(ind.row))
)
}
\arguments{
\item{X}{Could be any matrix-like object.}

\item{ind.row}{An optional vector of the row indices that are used.
If not specified, all rows are used. \strong{Don't use negative indices.}}

\item{ind.col}{An optional vector of the column indices that are used.
If not specified, all columns are used. \strong{Don't use negative indices.}}

\item{type}{Type of the Filebacked Big Matrix (default is \code{double}). Either
\itemize{
\item \code{"double"} (double precision -- 64 bits)
\item \code{"float"} (single precision -- 32 bits)
\item \code{"integer"}
\item \code{"unsigned short"}: can store integer values from 0 to 65535.
It has vocation to become the basis for a \code{FBM.code65536}.
\item \code{"raw"} or \code{"unsigned char"}: can store integer values from 0 to 255.
It is the basis for class \link[=FBM.code256-class]{FBM.code256} in order to
access 256 arbitrary different numeric values.
It is used in \href{https://goo.gl/pHCCmo}{package \strong{bigsnpr}}.
}}

\item{backingfile}{Path to the file storing the Big Matrix on disk.
\strong{An extension ".bk" will be automatically added.}
Default stores in the temporary directory.}

\item{block.size}{Maximum number of columns read at once.
Default uses \link{block_size}.}
}
\value{
A copy of the \link[=FBM-class]{FBM}.
}
\description{
Copy a Filebacked Big Matrix with possible subsetting.
}
\examples{
X <- FBM(10, 10, init = 1:100)
X[]
X2 <- big_copy(X, ind.row = 1:5)
X2[]

mat <- matrix(101:200, 10)
X3 <- big_copy(mat, type = "double")
X3[]

X.code <- big_attachExtdata()
class(X.code)
X2.code <- big_copy(X.code)
class(X2.code)
all.equal(X.code[], X2.code[])

}
