% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dl-bikedata.R
\name{dl_bikedata}
\alias{dl_bikedata}
\alias{download_bikedata}
\title{Download hire bicycle data}
\usage{
dl_bikedata(city, data_dir = tempdir(), dates = NULL, quiet = FALSE)

download_bikedata(city, data_dir = tempdir(), dates = NULL, quiet = FALSE)
}
\arguments{
\item{city}{City for which to download bike data, or name of corresponding
bike system (see Details below).}

\item{data_dir}{Directory to which to download the files}

\item{dates}{Character vector of dates to download data with dates formated
as YYYYMM.}

\item{quiet}{If FALSE, progress is displayed on screen}
}
\description{
Download data for subsequent storage via \link{store_bikedata}.
}
\note{
Only files that don't already exist in \code{data_dir} will be
downloaded, and this function may thus be used to update a directory of files
by downloading more recent files. If a particular file request fails,
downloading will continue regardless. To ensure all files are downloaded,
this function may need to be run several times until a message appears
declaring that 'All data files already exist'
}
\section{Details}{

This function produces (generally) zip-compressed data in R's temporary
directory. City names are not case sensitive, and must only be long enough to
unambiguously designate the desired city. Names of corresponding bike systems
can also be given.  Currently possible cities (with minimal designations in
parentheses) and names of bike hire systems are:
\tabular{lr}{
 Boston (bo)\tab Hubway\cr
 Chicago (ch)\tab Divvy Bikes\cr
 Washington, D.C. (dc)\tab Capital Bike Share\cr
 Los Angeles (la)\tab Metro Bike Share\cr
 London (lo)\tab Santander Cycles\cr
 Minnesota (mn)\tab NiceRide\cr
 New York City (ny)\tab Citibike\cr
 Philadelphia (ph)\tab Indego\cr
 San Francisco Bay Area (sf)\tab Ford GoBike\cr
}

Ensure you have a fast internet connection and at least 100 Mb space
}

\examples{
\dontrun{
dl_bikedata (city = 'New York City USA', dates = 201601:201613)
}
}
