% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_utils.R
\name{bb_pie}
\alias{bb_pie}
\title{Pie property for a Billboard.js chart}
\usage{
bb_pie(bb, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{...}{See \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.pie}}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Pie property for a Billboard.js chart
}
\examples{
billboarder() \%>\%
  bb_piechart(data = table(mtcars$cyl)) \%>\% 
  bb_pie(label = list(
    ratio = 0.5, 
    format = htmlwidgets::JS("function(value) {return d3.format('$')(value);}")
  ), 
  expand = FALSE)
  
}
