% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_bar_color_manual}
\alias{bb_bar_color_manual}
\title{Manual color for barchart}
\usage{
bb_bar_color_manual(bb, values)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{values}{A named vector, names represent the categories of the bar chart,
values correspond to colors. All categories must be present in the vector, in 
the same order of the chart.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Manual color for barchart
}
\note{
Must be called after \code{bb_bar}.
}
\examples{
\dontrun{

library("data.table")
library("billboarder")

data("mpg", package = "ggplot2")
setDT(mpg)

# all in blue
manufa <- unique(mpg$manufacturer)
cols <- rep("#08298A", length(manufa))
names(cols) <- manufa

# Nissan in red
cols[["nissan"]] <- "#DF0101"#' 

billboarder() \%>\%
  bb_barchart(data = mpg[, list(count = .N), by = manufacturer][order(count)]) \%>\%
  bb_bar_color_manual(values = cols)
}
}
