% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inf.Dorf.R
\name{Inf.Dorf}
\alias{Inf.Dorf}
\title{Informative two-stage hierarchical (Dorfman) testing}
\usage{
Inf.Dorf(p, Se, Sp, group.sz, obj.fn, weights, alpha)
}
\arguments{
\item{p}{the probability of disease, which can be an overall probability of disease,
from which a heterogeneous vector of individual probabilities will be generated, or
a vector of individual probabilities specified by the user}

\item{Se}{the sensitivity of the diagnostic test}

\item{Sp}{the specificity of the diagnostic test}

\item{group.sz}{a single block size for which to find the optimal configuration
out of all possible configurations and calculate the associated operating
characteristics, or a range of block sizes over which to find the optimal
testing configuration}

\item{obj.fn}{a list of objective functions which are minimized to find the
optimal testing configuration. Available options include "\kbd{ET}" (the expected
number of tests per individual), "\kbd{MAR}" (the expected number of tests divided
by the expected number of correct classifications, described in Malinovsky et al. (2016)),
\url{http://www.chrisbilder.com/grouptesting/HBTM/} for additional details.}

\item{weights}{a matrix of up to six sets of weights for the GR function. Each set of
weights is specified by a row of the matrix.}

\item{alpha}{a scale parameter for the beta distribution that specifies the degree of
heterogeneity for the generated probability vector}
}
\value{
A list containing:
\item{prob}{the overall probability of disease or vector of individual probabilities,
as specified by the user}
\item{alpha}{the level of heterogeneity used to generate the vector of individual
probabilities}
\item{Se}{the sensitivity of the diagnostic test}
\item{Sp}{the specificity of the diagnostic test}
\item{opt.ET, opt.MAR, opt.GR}{a list for each objective function specified by the
user, containing:
\describe{
\item{OTC}{a list specifying the optimal testing configuration, which includes:
\describe{
\item{Block.sz}{the block size/overall group size, which is not tested}
\item{pool.szs}{pool sizes for the first stage of testing}}}
\item{p.vec}{the sorted vector of individual probabilities}
\item{ET}{the expected testing expenditure for the OTC}
\item{value}{the value of the objective function per individual}
\item{PSe}{the overall pooling sensitivity for the algorithm}
\item{PSp}{the overall pooling specificity for the algorithm}
\item{PPPV}{the overall pooling positive predictive value for the algorithm}
\item{PNPV}{the overall pooling negative predictive value for the algorithm}}}
}
\description{
Find the optimal testing configuration for informative
two-stage hierarchical (Dorfman) testing and calculate the associated
operating characteristics.
}
\details{
This function finds the optimal testing configuration and computes
the associated operating characteristics for informative two-stage
hierarchical (Dorfman) testing, implemented via the pool-specific optimal
Dorfman (PSOD) method described in McMahan et al. (2012a). This function
finds the optimal testing configuration by considering all possible configurations
instead of using the greedy algorithm proposed for PSOD testing.
See Hitt et al. (2018) at \url{http://www.chrisbilder.com/grouptesting/HBTM/}
McMahan et al. (2012a), or Dorfman (1943) for additional details.
}
\examples{
# Find the optimal testing configuration for informative two-stage
#   hierarchical (Dorfman) testing
\dontrun{Inf.Dorf(p=0.01, Se=0.95, Sp=0.95, group.sz=3:20, obj.fn=c("ET", "MAR"),
weights=NULL, alpha=2)}

# Find the optimal testing configuration for informative two-stage
#  hierarchical (Dorfman) testing, for a specified vector of
#  individual probabilities

\dontrun{
set.seed(8791)
Inf.Dorf(p=rbeta(10,2,200), Se=0.90, Sp=0.90, group.sz=10,
obj.fn=c("ET", "MAR", "GR"),
weights=matrix(data=c(1,1,10,10), nrow=2, ncol=2, byrow=TRUE),
alpha=NA)
}
}
\references{
\emph{Dorfman, R. (1943)}. The detection of defective members of large populations.
\emph{The Annals of Mathematical Statistics, 14, 436-440}.

\emph{Graff, L.E. & Roeloffs, R. (1972)}. Group testing in the presence of test error;
an extension of the Dorfman procedure. \emph{Technometrics, 14, 113-122}.

\emph{Malinovsky, Y.; Albert, P.S. & Roy, A. (2016)}. Reader reaction: A note on the
evaluation of group testing algorithms in the presence of misclassification.
\emph{Biometrics, 72, 299-302}.

\emph{McMahan, C.S.; Tebbs, J.M. & Bilder, C.R. (2012a)}. Informative Dorfman screening.
\emph{Biometrics, 68, 287-296}.
}
\seealso{
\code{\link{NI.Dorf}} for non-informative
two-stage hierarchical (Dorfman) testing

\code{\link{OTC}} for finding the
optimal testing configuration for a number of standard group testing algorithms

\url{http://chrisbilder.com/grouptesting/HBTM}

Other Optimal Testing Configuration functions: \code{\link{Inf.Array}},
  \code{\link{Inf.D3}}, \code{\link{NI.A2M}},
  \code{\link{NI.Array}}, \code{\link{NI.D3}},
  \code{\link{NI.Dorf}}, \code{\link{OTC}}
}
\author{
Brianna Hitt
}
