% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span.R
\name{span}
\alias{span}
\title{Parse taxon or taxondf objects by a range of names}
\usage{
span(.data, ...)
}
\arguments{
\item{.data}{Input, object of class taxon}

\item{...}{Pass in two unquoted taxonomic rank names, and only two. May make this
more flexible in the future.}
}
\value{
A single or list of \code{taxon} class objects
}
\description{
Parse taxon or taxondf objects by a range of names
}
\examples{
# operating on `taxon` objects
out <- make_taxon(genus="Poa", epithet="annua", authority="L.",
   family='Poaceae', clazz='Poales', kingdom='Plantae', variety='annua')
out \%>\% span(kingdom, genus)

# operating on taxonomic data.frames
df <- data.frame(class=c('Magnoliopsida','Magnoliopsida','Magnoliopsida',
                         'Magnoliopsida','Magnoliopsida','Magnoliopsida'),
         order=c('Asterales','Asterales','Fagales','Poales','Poales','Poales'),
         family=c('Asteraceae','Asteraceae','Fagaceae','Poaceae','Poaceae','Poaceae'),
         genus=c('Helianthus','Helianthus','Quercus','Poa','Festuca','Holodiscus'),
         stringsAsFactors = FALSE)
(df2 <- taxon_df(df))

## filter to get a range of classes
df2 \%>\% span(order, genus)
df2 \%>\% span(family, genus)

## from taxa object
df2 \%>\% scatter \%>\% span(family, species)
}

