% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binspp_auxiliary.R
\name{first_step}
\alias{first_step}
\title{Estimate the first-order inhomogeneity}
\usage{
first_step(X, z_beta, W_dil, plot = TRUE)
}
\arguments{
\item{X}{observed point pattern in the \code{\link[spatstat.geom:ppp]{spatstat.geom::ppp()}} format of the \pkg{spatstat} package.}

\item{z_beta}{list of covariates describing the intensity function of the parent process, each covariate being a pixel image as used in the \pkg{spatstat} package.}

\item{W_dil}{the observation window dilated by the assumed maximal cluster radius.}

\item{plot}{logical, should the estimates intensity function of the parent process be plotted?}
}
\value{
List containing the output of the \code{\link[spatstat.core:ppm]{spatstat.core::ppm()}}
function from the \pkg{spatstat} package, along with some auxiliary
objects useful for running the MCMC chain.
}
\description{
For exploratory purposes it may be useful to perform the first
step of the analysis only, to investigate the dependence of
the intensity function of the parent process on given covariates,
without running the MCMC chain.
}
\details{
The calling the \code{\link[spatstat.core:ppm]{spatstat.core::ppm()}} function from the \pkg{spatstat}
package, with some additional computations useful when preparing
the run of the MCMC chain, is mainly performed in this function.
The function also contains a simple way to plot the estimated
intensity function of the parent process.
}
\examples{

library(spatstat)
# Prepare the dataset:
X = trees_N4
x_left = x_left_N4
x_right = x_right_N4
y_bottom = y_bottom_N4
y_top = y_top_N4

z_beta = list(refor = cov_refor, slope = cov_slope)

# Determine the union of rectangles:
W = owin(c(x_left[1], x_right[1]), c(y_bottom[1], y_top[1]))
if (length(x_left) >= 2){
  for (i in 2:length(x_left)){
    W2 = owin(c(x_left[i], x_right[i]), c(y_bottom[i], y_top[i]))
    W = union.owin(W, W2)
  }
}

# Dilated observation window:
W_dil = dilation.owin(W, 100)


# Estimating the intensity function of the parent process:
aux = first_step(X, z_beta, W_dil, plot = TRUE)

}
