% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OED_isothermal.R
\name{isothermal_OED}
\alias{isothermal_OED}
\title{Optimal Experiment Design of isothermal inactivation}
\usage{
isothermal_OED(model, pars, n_points, min_time, max_time, min_temp,
  max_temp, criterion = "D", opts = NULL)
}
\arguments{
\item{model}{character string defining the inactivation model to use.}

\item{pars}{list defining the nominal model parameters.}

\item{n_points}{numerical stating the number of data points.}

\item{min_time}{numerical stating the lower limit for the time points.}

\item{max_time}{numerical stating the upper limit for the time points.}

\item{min_temp}{numerical stating the lower limit for the temperature.}

\item{max_temp}{numerical stating the upper limit for the temperature.}

\item{criterion}{character stating the criterion to use for the OED.
function evaluations with local finish with the DHC algorithm 
(see help from MEIGO).}

\item{opts}{options for the MEIGO algorithm. By default, a maximum of 2000}
}
\value{
A MEIGO object
}
\description{
Calculates an Optimal Experiment for an isothermal microbial inactivation experiment
considering the maximum duration of the experiment according to the detection limit.
}
\examples{
pars <- list(z = 4.2, D_R = 3.9, temp_ref = 55)
opts <- list(maxeval=200,local_finish="DHC")
\dontrun{
OED <- isothermal_OED("Bigelow", pars, n_points = 5, criterion = "E-mod", 
                      min_time = 0, max_time = 100, min_temp = 52.5, max_temp = 60, 
                      opts = opts)
plot(OED)
}

}
