% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvolfile.R
\name{get_odim_object_type}
\alias{get_odim_object_type}
\title{Check the ODIM data class of a polar volume file}
\usage{
get_odim_object_type(file)
}
\arguments{
\item{file}{A string containing a file name.}
}
\value{
character string \code{pvol} for polar volume, \code{vp} for
vertical profile, otherwise \code{NA}
}
\description{
Checks which data class is contained in ODIM HDF5 file
}
\examples{
# locate a polar volume file
pvol <- system.file("extdata", "volume.h5", package = "bioRad")
get_odim_object_type(pvol) # > "pvol"
}
