% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvolfile.R
\name{get_odim_object_type}
\alias{get_odim_object_type}
\title{Check the data object contained in a ODIM HDF5 file}
\usage{
get_odim_object_type(file)
}
\arguments{
\item{file}{A string containing a file name.}
}
\value{
character string \code{PVOL} for polar volume, \code{VP} for
vertical profile.
}
\description{
Checks which data object is contained in ODIM HDF5 file
}
\details{
See \href{https://github.com/adokter/vol2bird/blob/master/doc/OPERA2014_O4_ODIM_H5-v2.2.pdf}{ODIM specification}
Table 2 for a full list of existing ODIM file object types.
}
\examples{
# locate a polar volume file:
pvolfile <- system.file("extdata", "volume.h5", package = "bioRad")

# check the data type:
get_odim_object_type(pvolfile) # > "PVOL"
}
