% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.vpi.R
\name{plot.vpi}
\alias{plot.vpi}
\title{Plot an integrated profile (\code{vpi})}
\usage{
\method{plot}{vpi}(
  x,
  quantity = "mtr",
  xlab = "time",
  ylab = "migration traffic rate [#/km/h]",
  main = "MTR",
  night_shade = TRUE,
  elev = -0.268,
  lat = NULL,
  lon = NULL,
  ylim = NULL,
  nightshade = TRUE,
  ...
)
}
\arguments{
\item{x}{1 class object inheriting from class \code{vpi}, typically a
call to \link[bioRad]{integrate_profile}.}

\item{quantity}{Character string with the quantity to plot, one of
'\code{vid}' (vertically integrated density),
'\code{vir}' (vertically integrated reflectivity),
'\code{mtr}' (migration traffic rate),
'\code{rtr}' (reflectivity traffic rate),
'\code{mt}' ((cumulative) migration traffic),
'\code{rt}' ((cumulative) reflectivity traffic),
'\code{ff}' (height-averaged ground speed)
'\code{dd}' (height-averaged direction)
'\code{u}' (height-averaged u-component of ground speed),
'\code{v}' (height-averaged v-component of ground speed).}

\item{xlab}{A title for the x-axis.}

\item{ylab}{A title for the y-axis.}

\item{main}{A title for the plot.}

\item{night_shade}{Logical, whether to plot night time shading.}

\item{elev}{Numeric, sun elevation to use for day/night transition,
see \link{sunrise}.}

\item{lat}{(optional) Latitude in decimal degrees. Overrides the lat
attribute of \code{x}.}

\item{lon}{(optional) Longitude in decimal degrees. Overrides the lon
attribute of \code{x}.}

\item{ylim}{y-axis plot range, numeric atomic vector of length 2.}

\item{nightshade}{Deprecated argument, use night_shade instead.}

\item{...}{Additional arguments to be passed to the low level
\link[graphics]{plot} plotting function.}
}
\description{
Plot an object of class \code{vpi}.
}
\details{
The integrated profiles can be visualized in various related quantities, as specified by
argument \code{quantity}:
\describe{
\item{"\code{vid}"}{Vertically Integrated Density, i.e. the aerial surface
density of individuals. This quantity is dependent on the assumed radar
cross section per individual (RCS)}
\item{"\code{vir}"}{Vertically Integrated Reflectivity. This quantity is
independent of the value of individual's radar cross section}
\item{"\code{mtr}"}{Migration Traffic Rate. This quantity is dependent on
the assumed radar cross section (RCS)}
\item{"\code{rtr}"}{Reflectivity Traffic Rate. This quantity is independent
on the assumed radar cross section (RCS)}
\item{"\code{mt}"}{Migration Traffic. This quantity is dependent on
the assumed radar cross section (RCS)}
\item{"\code{rt}"}{Reflectivity Traffic. This quantity is independent
on the assumed radar cross section (RCS)}
\item{\code{ff}}{Horizontal ground speed in m/s}
\item{\code{dd}}{Horizontal ground speed direction in degrees}
\item{\code{u}}{Ground speed component west to east in m/s}
\item{\code{v}}{Ground speed component south to north in m/s}
\item{\code{height}}{Mean flight height (height weighted by reflectivity eta) in m above sea level}
}
The height-averaged ground speed quantities (ff,dd,u,v) and height are weighted averages by reflectivity eta.
}
\examples{
# vertically integrate a vpts object:
vpi <- integrate_profile(example_vpts)
# plot the migration traffic rates
plot(vpi)
# plot the vertically integrated densities, without night shading:
plot(vpi, quantity = "vid", night_shade = FALSE)
}
