% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sd_vvp_threshold.R
\name{sd_vvp_threshold<-}
\alias{sd_vvp_threshold<-}
\alias{sd_vvp_threshold<-.vp}
\alias{sd_vvp_threshold<-.list}
\alias{sd_vvp_threshold<-.vpts}
\title{Set threshold of the radial velocity standard deviation}
\usage{
sd_vvp_threshold(x) <- value

\method{sd_vvp_threshold}{vp}(x) <- value

\method{sd_vvp_threshold}{list}(x) <- value

\method{sd_vvp_threshold}{vpts}(x) <- value
}
\arguments{
\item{x}{A \code{vp}, list of \code{vp} or \code{vpts} object.}

\item{value}{Numeric. The \code{sd_vvp} threshold value to assign in m/s.}
}
\description{
Sets the threshold of radial velocity standard deviation (\code{sd_vvp}) of an
object in m/s. Altitude layers with \code{sd_vvp} below this threshold are assumed
to have an aerial density of zero individuals. This function also updates the
migration densities in \code{x$data$dens} to \code{eta}/\code{rcs} when above
\code{sd_vvp_threshold} and \code{0} if below.
}
\examples{
# Set the sd_vvp threshold for a vp
vp <- example_vp
sd_vvp_threshold(vp) <- 2

# Set the sd_vvp threshold for a vpts
vpts <- example_vpts
sd_vvp_threshold(vpts) <- 2
}
\seealso{
\itemize{
\item \code{\link[=sd_vvp_threshold]{sd_vvp_threshold()}} for getting the \code{sd_vvp} threshold of an object.
\item \code{\link[=rcs<-]{rcs()<-}}
}
}
