% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_vpts.R
\name{read_vpts}
\alias{read_vpts}
\title{Read time series of vertical profiles (\code{vpts}) from file(s)}
\usage{
read_vpts(files, data_frame = FALSE, ...)
}
\arguments{
\item{files}{Path(s) to one or more files containing vpts data.}

\item{data_frame}{When \code{FALSE} (default) output a \code{vpts} object, when \code{TRUE} output a data.frame}

\item{...}{Additional arguments for backward compatibility, passed to \code{read_stdout}.}
}
\value{
\code{vpts} object.
}
\description{
Reads \code{vpts} data from one or more files.
The following file formats are supported (but cannot be mixed):
\itemize{
\item \href{https://aloftdata.eu/vpts-csv/}{VPTS CSV}.
\item \href{https://github.com/adokter/vol2bird/wiki/ODIM-bird-profile-format-specification}{ODIM bird profile}.
\item vol2bird standard output (see example below).
}
}
\examples{
## read a vertical profile time series in VPTS CSV format:
vptsfile <- system.file("extdata", "example_vpts.csv", package = "bioRad")
read_vpts(vptsfile)
# read a single vertical profile file in ODIM h5 format:
vpfile <- system.file("extdata", "profile.h5", package = "bioRad")
read_vpts(vpfile)
# read a vertical profile time series in `vol2bird` stdout format:
stdout_file <- system.file("extdata", "example_vpts.txt", package = "bioRad")
read_vpts(stdout_file, radar = "KBGM", wavelength = "S")
}
\concept{read functions}
