% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_estimation.R
\name{estimate_whole_body_delta}
\alias{estimate_whole_body_delta}
\title{Whole-body dose estimation (delta method)}
\usage{
estimate_whole_body_delta(
  case_data,
  fit_coeffs,
  fit_var_cov_mat,
  conf_int = 0.95,
  protracted_g_value = 1,
  aberr_module = c("dicentrics", "translocations", "micronuclei")
)
}
\arguments{
\item{case_data}{Case data in data frame form.}

\item{fit_coeffs}{Fitting coefficients matrix.}

\item{fit_var_cov_mat}{Fitting variance-covariance matrix.}

\item{conf_int}{Confidence interval, 95\% by default.}

\item{protracted_g_value}{Protracted \eqn{G(x)} value.}

\item{aberr_module}{Aberration module.}
}
\value{
List containing estimated doses data frame, AIC, and \code{conf_int} used.
}
\description{
Method based on 2001 manual by the International Atomic Energy Agency (IAEA).
Cytogenetic Analysis for Radiation Dose Assessment, Technical Reports Series
(2001). Retrieved from \url{https://www.iaea.org/publications/6303/cytogenetic-analysis-for-radiation-dose-assessment}.
}
