% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_sequence.R
\name{generate_unigrams}
\alias{generate_unigrams}
\title{Generate unigrams}
\usage{
generate_unigrams(unigram_list, unigram_names = NULL, prop_names = NULL)
}
\arguments{
\item{unigram_list}{a list of unigrams' parameters. See Details.}

\item{unigram_names}{names of unigrams. If not \code{NULL}, will
overwrite any existing unigram names.}

\item{prop_names}{names of properties. If not \code{NULL}, will 
overwrite any existing names.}
}
\description{
Generates an alphabet of unigrams based on given list of properties.
}
\details{
Unigram parameters are represented as a list of intervals, where 
each interval corresponds to a different property. The function generate 
unigrams randomly choosing values of properties from given intervals 
using uniform distribution. All lists of ranges should have the same length, 
which equils to describing each unigram using the same properties.
}
\examples{
props1 <- list(P1 = c(0, 0.5), 
               P2 = c(0.2, 0.4),
               P3 = c(0.5, 1),
               P4 = c(0, 0))

props2 <- list(P1 = c(0.5, 1), 
               P2 = c(0.4, 1),
               P3 = c(0, 0.5),
               P4 = c(1, 1))


alph <- generate_unigrams(c(replicate(8, props1, simplify = FALSE),
                          replicate(12, props2, simplify = FALSE)),
                          unigram_names = letters[1L:20])
                          
}
