% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynamicGrowth_class.R
\name{DynamicGrowth}
\alias{DynamicGrowth}
\alias{print.DynamicGrowth}
\alias{plot.DynamicGrowth}
\alias{coef.DynamicGrowth}
\title{DynamicGrowth class}
\usage{
\method{print}{DynamicGrowth}(x, ...)

\method{plot}{DynamicGrowth}(
  x,
  y = NULL,
  ...,
  add_factor = NULL,
  ylims = NULL,
  label_y1 = "logN",
  label_y2 = add_factor,
  line_col = "black",
  line_size = 1,
  line_type = "solid",
  line_col2 = "black",
  line_size2 = 1,
  line_type2 = "dashed",
  label_x = "time"
)

\method{coef}{DynamicGrowth}(object, ...)
}
\arguments{
\item{x}{The object of class \code{DynamicGrowth} to plot.}

\item{...}{ignored}

\item{y}{ignored}

\item{add_factor}{whether to plot also one environmental factor.
If \code{NULL} (default), no environmental factor is plotted. If set
to one character string that matches one entry of x$env_conditions,
that condition is plotted in the secondary axis}

\item{ylims}{A two dimensional vector with the limits of the primary y-axis.}

\item{label_y1}{Label of the primary y-axis.}

\item{label_y2}{Label of the secondary y-axis.}

\item{line_col}{Aesthetic parameter to change the colour of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_size}{Aesthetic parameter to change the thickness of the line geom in the plot, see: \code{\link[=geom_line]{geom_line()}}}

\item{line_type}{Aesthetic parameter to change the type of the line geom in the plot, takes numbers (1-6) or strings ("solid") see: \code{\link[=geom_line]{geom_line()}}}

\item{line_col2}{Same as lin_col, but for the environmental factor.}

\item{line_size2}{Same as line_size, but for the environmental factor.}

\item{line_type2}{Same as lin_type, but for the environmental factor.}

\item{label_x}{Label of the x-axis.}

\item{object}{an instance of \link{DynamicGrowth}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

The class \link{DynamicGrowth} has been superseded by the top-level
class \link{GrowthPrediction}, which provides a unified approach for growth modelling.

Still, it is returned if the superseded \code{\link[=predict_dynamic_growth]{predict_dynamic_growth()}} is called.

A subclass of list with items:
\itemize{
\item simulation: A tibble with the model prediction
\item gammas: A tibble with the value of each gamma factor for each
value of \code{times}.
\item env_conditions: A list of functions interpolating the environmental
conditions.
\item primary_pars: A list with the model parameters of the primary model.
\item sec_models: A nested list defining the secondary models.
}
}
\section{Functions}{
\itemize{
\item \code{print.DynamicGrowth}: print of the model

\item \code{plot.DynamicGrowth}: predicted growth curve under dynamic conditions.

\item \code{coef.DynamicGrowth}: coefficients of the model
}}

